/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

class Token {
    public static final int PERCENT = 37;
    public static final int RIGHT_PARENTHESIS = 41;
    public static final int MINUS = 45;
    public static final int DOT = 46;
    public static final int CURLY_LEFT = 123;
    public static final int CURLY_RIGHT = 125;
    public static final int LITERAL = 1000;
    public static final int FORMAT_MODIFIER = 1002;
    public static final int SIMPLE_KEYWORD = 1004;
    public static final int COMPOSITE_KEYWORD = 1005;
    public static final int OPTION = 1006;
    public static final int EOF = Integer.MAX_VALUE;
    public static Token EOF_TOKEN = new Token(Integer.MAX_VALUE, "EOF");
    public static Token RIGHT_PARENTHESIS_TOKEN = new Token(41);
    public static Token BARE_COMPOSITE_KEYWORD_TOKEN = new Token(1005, "BARE");
    public static Token PERCENT_TOKEN = new Token(37);
    private final int type;
    private final Object value;

    public Token(int type) {
        this(type, null);
    }

    public Token(int type, Object value) {
        this.type = type;
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        String typeStr = null;
        switch (this.type) {
            case 37: {
                typeStr = "%";
                break;
            }
            case 1002: {
                typeStr = "FormatModifier";
                break;
            }
            case 1000: {
                typeStr = "LITERAL";
                break;
            }
            case 1006: {
                typeStr = "OPTION";
                break;
            }
            case 1004: {
                typeStr = "SIMPLE_KEYWORD";
                break;
            }
            case 1005: {
                typeStr = "COMPOSITE_KEYWORD";
                break;
            }
            case 41: {
                typeStr = "RIGHT_PARENTHESIS";
                break;
            }
            default: {
                typeStr = "UNKNOWN";
            }
        }
        if (this.value == null) {
            return "Token(" + typeStr + ")";
        }
        return "Token(" + typeStr + ", \"" + this.value + "\")";
    }

    public int hashCode() {
        int result = this.type;
        result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token token = (Token)o;
        if (this.type != token.type) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(token.value) : token.value != null);
    }
}

