/*
 * Decompiled with CFR 0.152.
 */
package com.github.joonasvali.naturalmouse.api;

import com.github.joonasvali.naturalmouse.api.DeviationProvider;
import com.github.joonasvali.naturalmouse.api.MouseInfoAccessor;
import com.github.joonasvali.naturalmouse.api.MouseMotionObserver;
import com.github.joonasvali.naturalmouse.api.NoiseProvider;
import com.github.joonasvali.naturalmouse.api.OvershootManager;
import com.github.joonasvali.naturalmouse.api.SpeedManager;
import com.github.joonasvali.naturalmouse.api.SystemCalls;
import com.github.joonasvali.naturalmouse.support.DoublePoint;
import com.github.joonasvali.naturalmouse.support.Flow;
import com.github.joonasvali.naturalmouse.support.MouseMotionNature;
import com.github.joonasvali.naturalmouse.support.mousemotion.Movement;
import com.github.joonasvali.naturalmouse.support.mousemotion.MovementFactory;
import com.github.joonasvali.naturalmouse.util.MathUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MouseMotion {
    private static final Logger log = LoggerFactory.getLogger(MouseMotion.class);
    private static final int SLEEP_AFTER_ADJUSTMENT_MS = 2;
    private final int minSteps;
    private final int effectFadeSteps;
    private final int reactionTimeBaseMs;
    private final int reactionTimeVariationMs;
    private final double timeToStepsDivider;
    private final Dimension screenSize;
    private final SystemCalls systemCalls;
    private final DeviationProvider deviationProvider;
    private final NoiseProvider noiseProvider;
    private final SpeedManager speedManager;
    private final OvershootManager overshootManager;
    private final int xDest;
    private final int yDest;
    private final Random random;
    private final MouseInfoAccessor mouseInfo;
    private Point mousePosition;

    public MouseMotion(MouseMotionNature nature, Random random, int xDest, int yDest) {
        this.deviationProvider = nature.getDeviationProvider();
        this.noiseProvider = nature.getNoiseProvider();
        this.systemCalls = nature.getSystemCalls();
        this.screenSize = this.systemCalls.getScreenSize();
        this.xDest = this.limitByScreenWidth(xDest);
        this.yDest = this.limitByScreenHeight(yDest);
        this.random = random;
        this.mouseInfo = nature.getMouseInfo();
        this.speedManager = nature.getSpeedManager();
        this.timeToStepsDivider = nature.getTimeToStepsDivider();
        this.minSteps = nature.getMinSteps();
        this.effectFadeSteps = nature.getEffectFadeSteps();
        this.reactionTimeBaseMs = nature.getReactionTimeBaseMs();
        this.reactionTimeVariationMs = nature.getReactionTimeVariationMs();
        this.overshootManager = nature.getOvershootManager();
    }

    public void move() throws InterruptedException {
        this.move((x, y) -> {});
    }

    public void move(MouseMotionObserver observer) throws InterruptedException {
        this.updateMouseInfo();
        log.info("Starting to move mouse to ({}, {}), current position: ({}, {})", this.xDest, this.yDest, this.mousePosition.x, this.mousePosition.y);
        MovementFactory movementFactory = new MovementFactory(this.xDest, this.yDest, this.speedManager, this.overshootManager, this.screenSize);
        ArrayDeque<Movement> movements = movementFactory.createMovements(this.mousePosition);
        int overshoots = movements.size() - 1;
        while (this.mousePosition.x != this.xDest || this.mousePosition.y != this.yDest) {
            if (movements.isEmpty()) {
                this.updateMouseInfo();
                log.warn("Re-populating movement array. Did not end up on target pixel.");
                movements = movementFactory.createMovements(this.mousePosition);
            }
            Movement movement = movements.removeFirst();
            if (!movements.isEmpty()) {
                log.debug("Using overshoots ({} out of {}), aiming at ({}, {})", overshoots - movements.size() + 1, overshoots, movement.destX, movement.destY);
            }
            double distance = movement.distance;
            long mouseMovementMs = movement.time;
            Flow flow = movement.flow;
            double xDistance = movement.xDistance;
            double yDistance = movement.yDistance;
            log.debug("Movement arc length computed to {} and time predicted to {} ms", (Object)distance, (Object)mouseMovementMs);
            int steps = (int)Math.ceil(Math.min(distance, Math.max((double)mouseMovementMs / this.timeToStepsDivider, (double)this.minSteps)));
            long startTime = this.systemCalls.currentTimeMillis();
            long stepTime = (long)((double)mouseMovementMs / (double)steps);
            this.updateMouseInfo();
            double simulatedMouseX = this.mousePosition.x;
            double simulatedMouseY = this.mousePosition.y;
            double deviationMultiplierX = (this.random.nextDouble() - 0.5) * 2.0;
            double deviationMultiplierY = (this.random.nextDouble() - 0.5) * 2.0;
            double completedXDistance = 0.0;
            double completedYDistance = 0.0;
            double noiseX = 0.0;
            double noiseY = 0.0;
            for (int i = 0; i < steps; ++i) {
                double timeCompletion = (double)i / (double)steps;
                double effectFadeStep = Math.max(i - (steps - this.effectFadeSteps) + 1, 0);
                double effectFadeMultiplier = ((double)this.effectFadeSteps - effectFadeStep) / (double)this.effectFadeSteps;
                double xStepSize = flow.getStepSize(xDistance, steps, timeCompletion);
                double yStepSize = flow.getStepSize(yDistance, steps, timeCompletion);
                double completedDistance = Math.hypot(completedXDistance += xStepSize, completedYDistance += yStepSize);
                double completion = Math.min(1.0, completedDistance / distance);
                log.trace("Step: x: {} y: {} tc: {} c: {}", xStepSize, yStepSize, timeCompletion, completion);
                DoublePoint noise = this.noiseProvider.getNoise(this.random, xStepSize, yStepSize);
                DoublePoint deviation = this.deviationProvider.getDeviation(distance, completion);
                log.trace("EffectFadeMultiplier: {}", (Object)effectFadeMultiplier);
                log.trace("SimulatedMouse: [{}, {}]", (Object)(simulatedMouseX += xStepSize), (Object)(simulatedMouseY += yStepSize));
                long endTime = startTime + stepTime * (long)(i + 1);
                int mousePosX = MathUtil.roundTowards(simulatedMouseX + deviation.getX() * deviationMultiplierX * effectFadeMultiplier + (noiseX += noise.getX()) * effectFadeMultiplier, movement.destX);
                int mousePosY = MathUtil.roundTowards(simulatedMouseY + deviation.getY() * deviationMultiplierY * effectFadeMultiplier + (noiseY += noise.getY()) * effectFadeMultiplier, movement.destY);
                mousePosX = this.limitByScreenWidth(mousePosX);
                mousePosY = this.limitByScreenHeight(mousePosY);
                this.systemCalls.setMousePosition(mousePosX, mousePosY);
                observer.observe(mousePosX, mousePosY);
                long timeLeft = endTime - this.systemCalls.currentTimeMillis();
                this.sleepAround(Math.max(timeLeft, 0L), 0L);
            }
            this.updateMouseInfo();
            if (this.mousePosition.x != movement.destX || this.mousePosition.y != movement.destY) {
                log.warn("Mouse off from step endpoint (adjustment was done) x: (" + this.mousePosition.x + " -> " + movement.destX + ") y: (" + this.mousePosition.y + " -> " + movement.destY + ") ");
                this.systemCalls.setMousePosition(movement.destX, movement.destY);
                this.sleepAround(2L, 0L);
                this.updateMouseInfo();
            }
            if (this.mousePosition.x != this.xDest || this.mousePosition.y != this.yDest) {
                this.sleepAround(this.reactionTimeBaseMs, this.reactionTimeVariationMs);
            }
            log.debug("Steps completed, mouse at " + this.mousePosition.x + " " + this.mousePosition.y);
        }
        log.info("Mouse movement to ({}, {}) completed", (Object)this.xDest, (Object)this.yDest);
    }

    private int limitByScreenWidth(int value) {
        return Math.max(0, Math.min(this.screenSize.width - 1, value));
    }

    private int limitByScreenHeight(int value) {
        return Math.max(0, Math.min(this.screenSize.height - 1, value));
    }

    private void sleepAround(long sleepMin, long randomPart) throws InterruptedException {
        long sleepTime = (long)((double)sleepMin + this.random.nextDouble() * (double)randomPart);
        if (log.isTraceEnabled() && sleepTime > 0L) {
            this.updateMouseInfo();
            log.trace("Sleeping at ({}, {}) for {} ms", this.mousePosition.x, this.mousePosition.y, sleepTime);
        }
        this.systemCalls.sleep(sleepTime);
    }

    private void updateMouseInfo() {
        this.mousePosition = this.mouseInfo.getMousePosition();
    }
}

