/*
 * Decompiled with CFR 0.152.
 */
package com.github.joonasvali.naturalmouse.api;

import com.github.joonasvali.naturalmouse.api.DeviationProvider;
import com.github.joonasvali.naturalmouse.api.MouseInfoAccessor;
import com.github.joonasvali.naturalmouse.api.MouseMotion;
import com.github.joonasvali.naturalmouse.api.NoiseProvider;
import com.github.joonasvali.naturalmouse.api.OvershootManager;
import com.github.joonasvali.naturalmouse.api.SpeedManager;
import com.github.joonasvali.naturalmouse.api.SystemCalls;
import com.github.joonasvali.naturalmouse.support.DefaultMouseMotionNature;
import com.github.joonasvali.naturalmouse.support.MouseMotionNature;
import java.util.Random;

public class MouseMotionFactory {
    private static final MouseMotionFactory defaultFactory = new MouseMotionFactory();
    private MouseMotionNature nature;
    private Random random = new Random();

    public MouseMotionFactory(MouseMotionNature nature) {
        this.nature = nature;
    }

    public MouseMotionFactory() {
        this(new DefaultMouseMotionNature());
    }

    public MouseMotion build(int xDest, int yDest) {
        return new MouseMotion(this.nature, this.random, xDest, yDest);
    }

    public void move(int xDest, int yDest) throws InterruptedException {
        this.build(xDest, yDest).move();
    }

    public static MouseMotionFactory getDefault() {
        return defaultFactory;
    }

    public SystemCalls getSystemCalls() {
        return this.nature.getSystemCalls();
    }

    public void setSystemCalls(SystemCalls systemCalls) {
        this.nature.setSystemCalls(systemCalls);
    }

    public DeviationProvider getDeviationProvider() {
        return this.nature.getDeviationProvider();
    }

    public void setDeviationProvider(DeviationProvider deviationProvider) {
        this.nature.setDeviationProvider(deviationProvider);
    }

    public NoiseProvider getNoiseProvider() {
        return this.nature.getNoiseProvider();
    }

    public void setNoiseProvider(NoiseProvider noiseProvider) {
        this.nature.setNoiseProvider(noiseProvider);
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public MouseInfoAccessor getMouseInfo() {
        return this.nature.getMouseInfo();
    }

    public void setMouseInfo(MouseInfoAccessor mouseInfo) {
        this.nature.setMouseInfo(mouseInfo);
    }

    public SpeedManager getSpeedManager() {
        return this.nature.getSpeedManager();
    }

    public void setSpeedManager(SpeedManager speedManager) {
        this.nature.setSpeedManager(speedManager);
    }

    public MouseMotionNature getNature() {
        return this.nature;
    }

    public void setNature(MouseMotionNature nature) {
        this.nature = nature;
    }

    public void setOvershootManager(OvershootManager manager) {
        this.nature.setOvershootManager(manager);
    }

    public OvershootManager getOvershootManager() {
        return this.nature.getOvershootManager();
    }
}

