/*
 * Decompiled with CFR 0.152.
 */
package com.github.joonasvali.naturalmouse.support.mousemotion;

import com.github.joonasvali.naturalmouse.api.OvershootManager;
import com.github.joonasvali.naturalmouse.api.SpeedManager;
import com.github.joonasvali.naturalmouse.support.Flow;
import com.github.joonasvali.naturalmouse.support.mousemotion.Movement;
import com.github.joonasvali.naturalmouse.util.Pair;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovementFactory {
    private static final Logger log = LoggerFactory.getLogger(MovementFactory.class);
    private final int xDest;
    private final int yDest;
    private final SpeedManager speedManager;
    private final OvershootManager overshootManager;
    private final Dimension screenSize;

    public MovementFactory(int xDest, int yDest, SpeedManager speedManager, OvershootManager overshootManager, Dimension screenSize) {
        this.xDest = xDest;
        this.yDest = yDest;
        this.speedManager = speedManager;
        this.overshootManager = overshootManager;
        this.screenSize = screenSize;
    }

    public ArrayDeque<Movement> createMovements(Point currentMousePosition) {
        ArrayDeque<Movement> movements = new ArrayDeque<Movement>();
        int lastMousePositionX = currentMousePosition.x;
        int lastMousePositionY = currentMousePosition.y;
        int xDistance = this.xDest - lastMousePositionX;
        int yDistance = this.yDest - lastMousePositionY;
        double initialDistance = Math.hypot(xDistance, yDistance);
        Pair<Flow, Long> flowTime = this.speedManager.getFlowWithTime(initialDistance);
        Flow flow = (Flow)flowTime.x;
        long mouseMovementMs = (Long)flowTime.y;
        int overshoots = this.overshootManager.getOvershoots(flow, mouseMovementMs, initialDistance);
        if (overshoots == 0) {
            log.debug("No overshoots for movement from ({}, {}) -> ({}, {})", currentMousePosition.x, currentMousePosition.y, this.xDest, this.yDest);
            movements.add(new Movement(this.xDest, this.yDest, initialDistance, xDistance, yDistance, mouseMovementMs, flow));
            return movements;
        }
        for (int i = overshoots; i > 0; --i) {
            Point overshoot = this.overshootManager.getOvershootAmount(this.xDest - lastMousePositionX, this.yDest - lastMousePositionY, mouseMovementMs, i);
            int currentDestinationX = this.limitByScreenWidth(this.xDest + overshoot.x);
            int currentDestinationY = this.limitByScreenHeight(this.yDest + overshoot.y);
            xDistance = currentDestinationX - lastMousePositionX;
            yDistance = currentDestinationY - lastMousePositionY;
            double distance = Math.hypot(xDistance, yDistance);
            flow = (Flow)this.speedManager.getFlowWithTime((double)distance).x;
            movements.add(new Movement(currentDestinationX, currentDestinationY, distance, xDistance, yDistance, mouseMovementMs, flow));
            lastMousePositionX = currentDestinationX;
            lastMousePositionY = currentDestinationY;
            mouseMovementMs = this.overshootManager.deriveNextMouseMovementTimeMs(mouseMovementMs, i - 1);
        }
        Iterator it = movements.descendingIterator();
        boolean remove = true;
        while (it.hasNext() && remove) {
            Movement movement = (Movement)it.next();
            if (movement.destX == this.xDest && movement.destY == this.yDest) {
                lastMousePositionX = movement.destX - movement.xDistance;
                lastMousePositionY = movement.destY - movement.yDistance;
                log.trace("Pruning 0-overshoot movement (Movement to target) from the end. " + movement);
                it.remove();
                continue;
            }
            remove = false;
        }
        xDistance = this.xDest - lastMousePositionX;
        yDistance = this.yDest - lastMousePositionY;
        double distance = Math.hypot(xDistance, yDistance);
        Pair<Flow, Long> movementToTargetFlowTime = this.speedManager.getFlowWithTime(distance);
        long finalMovementTime = this.overshootManager.deriveNextMouseMovementTimeMs((Long)movementToTargetFlowTime.y, 0);
        Movement finalMove = new Movement(this.xDest, this.yDest, distance, xDistance, yDistance, finalMovementTime, (Flow)movementToTargetFlowTime.x);
        movements.add(finalMove);
        log.debug("{} movements returned for move ({}, {}) -> ({}, {})", movements.size(), currentMousePosition.x, currentMousePosition.y, this.xDest, this.yDest);
        log.trace("Movements are: {} ", (Object)movements);
        return movements;
    }

    private int limitByScreenWidth(int value) {
        return Math.max(0, Math.min(this.screenSize.width - 1, value));
    }

    private int limitByScreenHeight(int value) {
        return Math.max(0, Math.min(this.screenSize.height - 1, value));
    }
}

