/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwhat.jnativehook;

import com.github.kwhat.jnativehook.GlobalScreen;
import com.github.kwhat.jnativehook.NativeLibraryLocator;
import com.github.kwhat.jnativehook.NativeSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class DefaultLibraryLocator
implements NativeLibraryLocator {
    private static final Logger log = Logger.getLogger(GlobalScreen.class.getPackage().getName());

    @Override
    public Iterator<File> getLibraries() {
        ArrayList<File> libraries = new ArrayList<File>(1);
        String libName = System.getProperty("jnativehook.lib.name", "JNativeHook");
        String basePackage = GlobalScreen.class.getPackage().getName().replace('.', '/');
        String libNativeArch = NativeSystem.getArchitecture().toString().toLowerCase();
        String libNativeName = System.mapLibraryName(libName).replaceAll("\\.jnilib$", "\\.dylib");
        String libResourcePath = "/" + basePackage + "/lib/" + NativeSystem.getFamily().toString().toLowerCase() + "/" + libNativeArch + "/" + libNativeName;
        URL classLocation = GlobalScreen.class.getProtectionDomain().getCodeSource().getLocation();
        File classFile = null;
        try {
            classFile = new File(classLocation.toURI());
        }
        catch (URISyntaxException e) {
            log.warning(e.getMessage());
            classFile = new File(classLocation.getPath());
        }
        File libFile = null;
        if (classFile.isFile()) {
            String libPath = System.getProperty("jnativehook.lib.path", classFile.getParentFile().getPath());
            InputStream resourceInputStream = GlobalScreen.class.getResourceAsStream(libResourcePath);
            if (resourceInputStream == null) {
                throw new RuntimeException("Unable to extract the native library " + libResourcePath + "!\n");
            }
            Object version = GlobalScreen.class.getPackage().getImplementationVersion();
            version = version != null ? "-" + (String)version : "";
            libFile = new File(libPath, libNativeName.replaceAll("^(.*)\\.(.*)$", "$1" + (String)version + "." + libNativeArch + ".$2"));
            if (!libFile.exists()) {
                try {
                    int size;
                    FileOutputStream libOutputStream = new FileOutputStream(libFile);
                    byte[] buffer = new byte[4096];
                    while ((size = resourceInputStream.read(buffer)) != -1) {
                        libOutputStream.write(buffer, 0, size);
                    }
                    resourceInputStream.close();
                    libOutputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                log.fine("Extracted library: " + libFile.getPath() + ".\n");
            }
        } else {
            libFile = Paths.get(classFile.getAbsolutePath(), libResourcePath.toString()).toFile();
        }
        if (!libFile.exists()) {
            throw new RuntimeException("Unable to locate JNI library at " + libFile.getPath() + "!\n");
        }
        log.fine("Loading library: " + libFile.getPath() + ".\n");
        libraries.add(libFile);
        return libraries.iterator();
    }
}

