/*
 * Decompiled with CFR 0.152.
 */
package nom.actions;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogFile
extends AppenderBase<ILoggingEvent> {
    public static JFrame jFrame;
    public static JTextArea jTextArea;
    public static JScrollPane areaScrollPane;
    public PatternLayoutEncoder encoder;

    public LogFile() {
        jFrame = new JFrame("Log file");
        jTextArea = new JTextArea();
        areaScrollPane = new JScrollPane(jTextArea);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setPreferredSize(new Dimension(500, 250));
        jFrame.setContentPane(areaScrollPane);
        jTextArea.setAutoscrolls(true);
    }

    @Override
    protected void append(ILoggingEvent iLoggingEvent) {
        if (this.encoder == null) {
            this.addError("No encoder set for the appender named [" + this.name + "].");
            return;
        }
        String s = new String(this.encoder.encode(iLoggingEvent));
        if (jTextArea.getText().length() > 1000) {
            jTextArea.setText("");
        }
        jTextArea.append(s);
    }

    public PatternLayoutEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(PatternLayoutEncoder encoder) {
        this.encoder = encoder;
    }

    public static void showLog() {
        if (!jFrame.isVisible()) {
            jFrame.setLocationRelativeTo(null);
            jFrame.pack();
            jFrame.setVisible(true);
        }
    }

    public static JButton logButton() {
        JButton button = new JButton("Show log");
        button.addActionListener(l2 -> LogFile.showLog());
        return button;
    }
}

