/*
 * Decompiled with CFR 0.152.
 */
package nom.actions;

import com.github.joonasvali.naturalmouse.util.FactoryTemplates;
import com.github.kwhat.jnativehook.mouse.NativeMouseEvent;
import com.google.gson.annotations.SerializedName;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import nom.actions.ClickType;
import nom.actions.MacroAction;
import nom.actions.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroMouseAction
extends MacroAction {
    private static final Logger log = LoggerFactory.getLogger(MacroMouseAction.class);
    @SerializedName(value="x")
    private int x;
    @SerializedName(value="y")
    private int y;
    @SerializedName(value="ct")
    private ClickType type;
    private static transient long lastMove = System.currentTimeMillis();
    private static transient Point lastPoint = null;

    public MacroMouseAction(int order, long delay, NativeMouseEvent event) {
        super(order, delay);
        this.x = event.getX();
        this.y = event.getY();
        this.type = ClickType.eventToType(event);
    }

    public MacroMouseAction(int order, long delay, ClickType type) {
        super(order, delay);
        Point p = MouseInfo.getPointerInfo().getLocation();
        this.x = (int)p.getX();
        this.y = (int)p.getY();
        this.type = type;
    }

    @Override
    public void playback(Robot bot, Settings settings) {
        super.playback(bot, settings);
        Point thisPoint = new Point(this.x, this.y);
        double distance = MouseInfo.getPointerInfo().getLocation().distance(thisPoint);
        if (this.order < 2 && distance > 10.0) {
            for (int i = 0; i < 5; ++i) {
                try {
                    FactoryTemplates.createFastGamerMotionFactory().build(this.x, this.y).move();
                }
                catch (InterruptedException e) {
                    log.error("NaturalMotionError: ", e);
                }
                if (MouseInfo.getPointerInfo().getLocation().distance(thisPoint) < 5.0) break;
            }
        }
        switch (this.type) {
            case MOVE: {
                this.moveRetry(bot, this.x, this.y);
                lastMove = System.currentTimeMillis();
                lastPoint = thisPoint;
                break;
            }
            case LEFT_CLICK: {
                this.moveRetry(bot, this.x, this.y, 4);
                bot.mousePress(1024);
                break;
            }
            case MIDDLE_CLICK: {
                this.moveRetry(bot, this.x, this.y, 4);
                bot.mousePress(2048);
                break;
            }
            case RIGHT_CLICK: {
                this.moveRetry(bot, this.x, this.y, 4);
                bot.mousePress(4096);
                break;
            }
            case LEFT_RELEASE: {
                bot.mouseRelease(1024);
                break;
            }
            case MIDDLE_RELEASE: {
                bot.mouseRelease(2048);
                break;
            }
            case RIGHT_RELEASE: {
                bot.mouseRelease(4096);
                break;
            }
            case WHEEL_UP: {
                break;
            }
        }
    }

    private void moveRetry(Robot bot, int x, int y) {
        this.moveRetry(bot, x, y, 1);
    }

    private void moveRetry(Robot bot, int x, int y, int times) {
        Point dest = new Point(x, y);
        for (int i = 0; i < times; ++i) {
            bot.mouseMove(x, y);
            double d = MouseInfo.getPointerInfo().getLocation().distance(dest);
            if (d > 0.0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            return;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public ClickType getType() {
        return this.type;
    }
}

