/*
 * Decompiled with CFR 0.152.
 */
package nom.actions;

import com.github.kwhat.jnativehook.keyboard.NativeKeyEvent;
import com.github.kwhat.jnativehook.mouse.NativeMouseEvent;
import com.google.gson.annotations.SerializedName;
import java.util.Comparator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import nom.actions.ClickType;
import nom.actions.MacroAction;
import nom.actions.MacroKeyAction;
import nom.actions.MacroMouseAction;

public class Record {
    @SerializedName(value="keyActions")
    private CopyOnWriteArrayList<MacroKeyAction> keyActions = new CopyOnWriteArrayList();
    @SerializedName(value="mouseActions")
    private CopyOnWriteArrayList<MacroMouseAction> mouseActions = new CopyOnWriteArrayList();
    private transient CopyOnWriteArrayList<MacroAction> allActions = new CopyOnWriteArrayList();
    private transient AtomicInteger order;
    private transient long lastAction = System.currentTimeMillis();
    private transient NativeMouseEvent lastMouseEvent = null;

    public Record() {
        this.order = new AtomicInteger(0);
    }

    public void addAction(MacroAction action) {
        this.lastAction = System.currentTimeMillis();
        this.allActions.add(action);
    }

    public void addKeyEvent(NativeKeyEvent nativeKeyEvent) {
        MacroKeyAction action = new MacroKeyAction(this.order.getAndIncrement(), this.getCurrentDelay(), nativeKeyEvent);
        this.keyActions.add(action);
        this.addAction(action);
    }

    public void addMouseEvent(NativeMouseEvent nativeMouseEvent) {
        if (this.order.get() >= 1 && ClickType.eventToType(nativeMouseEvent) == ClickType.MOVE && this.lastMouseEvent != null) {
            if (this.lastMouseEvent.getX() == nativeMouseEvent.getX() && this.lastMouseEvent.getY() == nativeMouseEvent.getY()) {
                return;
            }
            if (this.getCurrentDelay() <= 4L) {
                return;
            }
        }
        this.lastMouseEvent = nativeMouseEvent;
        MacroMouseAction action = new MacroMouseAction(this.order.getAndIncrement(), this.getCurrentDelay(), nativeMouseEvent);
        this.mouseActions.add(action);
        this.addAction(action);
    }

    public void finish() {
        MacroMouseAction action = new MacroMouseAction(this.order.getAndIncrement(), this.getCurrentDelay(), ClickType.MOVE);
        this.mouseActions.add(action);
        this.addAction(action);
    }

    public CopyOnWriteArrayList<MacroAction> getLoop() {
        if (this.allActions == null || this.allActions.isEmpty()) {
            this.allActions = new CopyOnWriteArrayList();
            this.allActions.addAll(this.keyActions);
            this.allActions.addAll(this.mouseActions);
            this.allActions.sort(Comparator.comparing(MacroAction::getOrder));
        }
        return this.allActions;
    }

    private long getCurrentDelay() {
        return System.currentTimeMillis() - this.lastAction;
    }

    public String toString() {
        return "Keys " + this.keyActions.size() + " Clicks " + this.mouseActions.size();
    }

    public CopyOnWriteArrayList<MacroMouseAction> getMouseActions() {
        return this.mouseActions;
    }
}

