/*
 * Decompiled with CFR 0.152.
 */
package nom.actions;

import com.google.gson.annotations.SerializedName;
import java.time.LocalDate;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import nom.actions.MacroAction;
import nom.actions.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recording {
    private static final Logger log = LoggerFactory.getLogger(Recording.class);
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="date")
    private LocalDate date;
    private transient Record record;
    private transient Record lastPlayedRecord;
    private transient Record nextRecordToPlay;
    @SerializedName(value="records")
    private CopyOnWriteArrayList<Record> records;

    public Recording(String name, String description) {
        this.name = name;
        this.description = description;
        this.date = LocalDate.now();
        this.record = new Record();
        this.records = new CopyOnWriteArrayList();
    }

    public void createCycle() {
        log.info("Create cycle");
        this.record.finish();
        this.records.add(this.record);
        this.record = new Record();
    }

    public CopyOnWriteArrayList<MacroAction> currentLoop() {
        this.lastPlayedRecord = this.nextRecordToPlay == null ? this.records.get(ThreadLocalRandom.current().nextInt(this.records.size())) : this.nextRecordToPlay;
        this.nextRecordToPlay = this.records.get(ThreadLocalRandom.current().nextInt(this.records.size()));
        log.info(this.lastPlayedRecord.toString());
        return this.lastPlayedRecord.getLoop();
    }

    public void startRecording() {
        this.record = new Record();
    }

    public void stopRecording() {
        this.createCycle();
    }

    public long totalDuration() {
        long duration = 0L;
        for (Record record1 : this.records) {
            duration += record1.getLoop().stream().mapToLong(MacroAction::getDelay).sum();
        }
        return duration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public Record getRecord() {
        return this.record;
    }

    public Record getLastPlayedRecord() {
        return this.lastPlayedRecord;
    }

    public Record getNextRecordToPlay() {
        return this.nextRecordToPlay;
    }

    public void setNextRecordToPlay(Record nextRecordToPlay) {
        this.nextRecordToPlay = nextRecordToPlay;
    }

    public CopyOnWriteArrayList<Record> getRecords() {
        return this.records;
    }
}

